<?php

namespace App\Traits;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

trait Crud {

    // public $model;
    // public $searchable;
    // public $list_fields = array();

    public function getList(Request $request) {
        $show = $request->show ? $request->show : 2;
        $query = $this->getListQuery($request);
        $results = $query->paginate($show);

        // Total number of records
        $results_count = $query->count();

        return array('results_count' => $results_count, 'results' => $results);
    }

    public function publish(Request $request) {
        $resource = $this->getModel();
        $fillable_columns = $resource->getFillable();
        foreach ($fillable_columns as $column) {
            $resource->$column = $request->$column;
        }
        if (!$resource->save()) {
            print_r($resource->errors()->all());
            die;
            return false;
        } else {
            return array('message' => 'success', 'id' => $resource->id);
        }
    }

    public function view(Request $request) {
        $result = $this->getModel($request->id);
        return array('result' => $result);
    }

    public function revise(Request $request, $id) {
        $resource = $this->getModel($request->id);
        $fillable_columns = $resource->getFillable();
        if ($resource) {
            foreach ($fillable_columns as $column) {
                $resource->$column = $request->$column;
            }
            if (!$resource->save()) {
                print_r($resource->errors()->all());
                die;
                return false;
            } else {
                return array('message' => 'success', 'id' => $resource->id);
            }
        }
    }

    public function remove(Request $request) {
        $table = $this->getModel()->getTable();
        $result = $this->getModelNamespace()::whereIn('id', $request->ids)->delete();
        return array('message' => $result);
    }

    public function getModelNamespace() {
        $model_str = 'App\Models\\' . ucfirst(Str::singular($this->model));
        return $model_str;
    }

    public function getModel($id = null) {
        $model_str = $this->getModelNamespace();
        if ($id) {
            $connection_object = $model_str::find($id);
        } else {
            $connection_object = new $model_str;
        }
        return $connection_object;
    }

    public function getListQuery(Request $request) {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }

        //        if(!empty($this->join_colums)){
        //            $raw_sql .= implode($this->join_colums);
        //        }

        $query = DB::table($table)
                ->select(DB::raw($raw_sql));

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];

            foreach ($where_fields as $key => $where_field) {
                $query->where($where_field, $where_values[$key]);
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $table . '.' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        $query->where('deleted_at', null);
        $query->orderBy($sort, $sort_order);

        return $query;
    }

}
