<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Setting extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['question', 'answer', 'active'];
    protected $fillable = ['id', 'field_name', 'field_label', 'field_value'];
    public $searchable = ['id', 'field_name', 'field_label', 'field_value'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'setting';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'field_name' => array(
            'field_name' => 'field_name',
            'db_name' => 'field_name',
            'type' => 'text',
            'placeholder' => 'Field Name',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'field_label' => array(
            'field_name' => 'field_label',
            'db_name' => 'field_label',
            'type' => 'text',
            'placeholder' => 'Field Label',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'field_value' => array(
            'field_name' => 'field_value',
            'db_name' => 'field_value',
            'type' => 'textarea',
            'placeholder' => 'Field Value',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '100'
        )
    );
}