<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use App\Models\Product;

class Publisher extends BaseModel {

    use SoftDeletes;

    protected static $logAttributes = ['name'];
    protected $fillable = ['name'];
    public $searchable = ['name'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'publisher';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'name' => array(
            'field_name' => 'name',
            'db_name' => 'name',
            'type' => 'text',
            'placeholder' => 'Name',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'product' => array(
            'field_name' => 'product',
            'db_name' => 'product_id',
            'type' => 'autocomplete',
            'multiple' => true,
            'related_table' => 'products',
            'searchable' => 'product',
            'placeholder' => 'Product',
            'listing' => false,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'options' => [],
        ),
    );

    function __construct($arguments = array()) {
        parent::__construct($arguments);
        // $this->fields_array['product']['options'] = $this->getAllProducts();
        $product_of_this_publisher = $this->getThisProducts();
    }

    public function products() {
        return $this->belongsToMany('App\Models\Product');
    }

    public function getAllProducts() {
        $products_arr = [];
        $products = Product::all();
        foreach ($products as $product) {
            $products_arr[$product->id] = $product->product;
        }
        return $products_arr;
    }

    public function getThisProducts() {
        return $this->products()->get();
    }

}
