<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Product extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['product'];
    protected $fillable = ['product'];
    public $searchable = ['product'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'product';
    
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'product' => array(
            'field_name' => 'product',
            'db_name' => 'product',
            'type' => 'text',
            'placeholder' => 'Name',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        )
    );
}
