<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use App\Models\User;

class Keyword extends BaseModel {

    use SoftDeletes;

//    protected static $logAttributes = ['user_id', 'organisation_code'];
    protected $fillable = ['user_id', 'organisation_code'];
    public $searchable = ['user_id', 'organisation_code'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'keyword';
    public $select_fields = ['keywords.id as id', 'CONCAT(users.first_name, " ",users.last_name) as user_id', 'organisation_code'];
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
//        'user_id' => array(
//            'field_name' => 'user_id',
//            'db_name' => 'user_id',
//            'type' => 'autocomplete',
//            'multiple' => false,
//            'related_table' => 'users',
//            'searchable' => 'first_name',
//            'placeholder' => 'User',
//            'listing' => true,
//            'default_sort' => false,
//            'required' => true,
//            'value' => '',
//            'width' => '50',
//            'options' => [],
//        ),
        'organisation_code' => array(
            'field_name' => 'organisation_code',
            'db_name' => 'organisation_code',
            'type' => 'text',
            'placeholder' => 'Organization Code',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '100'
        ),
//        'active' => array(
//            'field_name' => 'active',
//            'db_name' => 'active',
//            'type' => 'switch',
//            'placeholder' => 'Active',
//            'listing' => true,
//            'sort' => true,
//            'required' => true,
//            'value' => '',
//            'width' => '25'
//        )
    );

    public function user() {
        return $this->belongsTo('App\Models\User');
    }

    public function getListQuery(Request $request) {
        $query = parent::getListQuery($request);
        $query->leftJoin('users', 'keywords.user_id', 'users.id');
        if ($request->user()->roles->first()->id == 17) {
            $query->where('users.company_id', $request->user()->id);
        } elseif ($request->user()->roles->first()->id == 18) {
            $query->where('users.company_id', $request->user()->id)->orWhere('users.id', $request->user()->id);
        } elseif ($request->user()->roles->first()->id == 19) {
            $query->where('users.id', $request->user()->id);
        }
        return $query;
    }

}
