<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends BaseModel {
    
    use SoftDeletes;
    protected $fillable = ['comment','post_id'];
    //protected $with = ['post'];
    public $searchable = [];
    public $default_sort = 'id';
    public $default_sort_order = 'asc';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'title' => array(
            'field_name' => 'title',
            'db_name' => 'title',
            'type' => 'text',
            'placeholder' => 'Title',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'description' => array(
            'field_name' => 'description',
            'db_name' => 'description',
            'type' => 'textarea',
            'placeholder' => 'Description',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        )
    );
    
    public function post(){
        return $this->belongsTo('App\Models\Post');
        //return $this->belongsTo(\App\Models\Post::class)->select('*');
    }
}
