<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Channel extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['channel',];
    protected $fillable = ['channel',];
    public $searchable = ['channel',];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'channel';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'channel' => array(
            'field_name' => 'channel',
            'db_name' => 'channel',
            'type' => 'text',
            'placeholder' => 'Channel',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
    );
}
