<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
// use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
// use Spatie\Activitylog\LogOptions;


class BaseModel extends Model
{

    use SoftDeletes;

    // use LogsActivity;

    public $model;
    public $searchable;
    public $list_fields = array();

    /**
     * For the proper use of Spatie change logs
     * updated on 27-01-20
     * ------------------------------------------------------------------------------------
     */
    // To prevent storing log of timestamp values
    // protected static $logAttributesToIgnore = ['updated_at'];
    // // To only store a field that has changed
    // protected static $logOnlyDirty = false;
    // // Not to store empty log changes as a row
    // protected static $submitEmptyLogs = false;

    /* ------------------------------------------------------------------------------------ */

    public static function boot()
    {
        parent::boot();
    }

    // public function getActivitylogOptions(): 
    // {
    //     return "";
    // }

    public function getList(Request $request)
    {
        $show = $request->show ? $request->show : 2;
        $query = $this->getListQuery($request);
        $results = $query->paginate($show);

        // Total number of records
        $results_count = $query->count();

        return array('results_count' => $results_count, 'results' => $results);
    }

    public function publish(Request $request)
    {
        $resource = $this->getModel();
        $fillable_columns = $resource->getFillable();
        foreach ($fillable_columns as $column) {
            $resource->$column = $request->$column;
        }

        if ($resource->model == 'keyword') {
            $resource->user_id = $request->user()->id;
            $la_getKeyword = \App\Models\Keyword::where('organisation_code', $resource->organisation_code)->get()->toArray();
            if (count($la_getKeyword) != 0) {
                return [
                    'status' => false,
                    'message' => 'Organisation Code already taken!'
                ];
            }
        }

        if (!$resource->save()) {
            // print_r($resource->errors()->all());
            // die;
            return false;
        } else {
            return array('message' => 'success', 'id' => $resource->id, 'object' => $resource);
        }
    }

    public function view(Request $request)
    {
        $result = $this->getModel($request->id);
        return array('result' => $result);
    }

    public function revise(Request $request, $id)
    {
        $resource = $this->getModel($request->id);
        $fillable_columns = $resource->getFillable();

        if ($resource) {
            foreach ($fillable_columns as $column) {
                if (!is_null($request->$column)) {
                    $resource->$column = $request->$column;
                }
            }
            if ($resource->model == 'keyword') {
                $resource->user_id = $request->user()->id;
                $la_getKeyword = \App\Models\Keyword::where('organisation_code', $resource->organisation_code)->where('id', '!=', $resource->id)->get()->toArray();
                if (count($la_getKeyword) != 0) {
                    return [
                        'status' => false,
                        'message' => 'Organisation Code already taken!'
                    ];
                }
            }
            if (!$resource->save()) {
                print_r($resource->errors()->all());
                die;
                return false;
            } else {
                return array('message' => 'success', 'id' => $resource->id, 'object' => $resource);
            }
        }
    }

    public function remove(Request $request)
    {
        $table = $this->getModel()->getTable();
        $result = $this->getModelNamespace()::whereIn('id', $request->ids)->delete();
        return array('message' => $result);
    }

    public function deletePermanently(Request $request)
    {
        $table = $this->getModel()->getTable();
        $result = $this->getModelNamespace()::whereIn('id', $request->ids)->forceDelete();
        return array('message' => count($request->ids));
    }

    public function getModelNamespace()
    {

        $model_str = 'App\Models\\' . ucfirst(Str::singular($this->model));
        return $model_str;
    }

    public function getModel($id = null)
    {
        $model_str = $this->getModelNamespace();
        if ($id) {
            $connection_object = $model_str::find($id);
        } else {
            $connection_object = new $model_str;
        }

        return $connection_object;
    }

    public function getListQuery(Request $request)
    {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }

        $query = DB::table($table)
            ->select(DB::raw($raw_sql));

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $table . '.' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        if ($trash == 'false') {
            $query->whereNull($table . '.deleted_at');
        } else {
            $query->whereNotNull($table . '.deleted_at');
        }
        $query->orderBy($sort, $sort_order);

        return $query;
    }

    public function revert(Request $request)
    {
        $restore_all = (string) $request->restore_all;
        $table = $this->getModel()->getTable();
        $counter = 0;
        if ($restore_all == 'false') {
            DB::table($table)->whereIn('id', $request->ids)->update(['deleted_at' => null]);
            $counter = count($request->ids);
        } else {
            $ids = DB::table($table)->whereNotNull('deleted_at')->get()->pluck('id');
            DB::table($table)->whereIn('id', $ids)->update(['deleted_at' => null]);
            $counter = count($ids);
        }
        return array('message' => $counter);
    }

    public function getCompanies()
    {
        $company_arr = array();
        $companies = \App\Models\Company::All();
        foreach ($companies as $company) {
            $company_arr[$company->id] = $company->name;
        }
        return $company_arr;
    }

    public function fetchDropdownOptions(Request $request)
    {
        $result_array = array();
        $search = $request->search;
        $column = $request->column;
        $results = $this->getModel()::where($column, 'like', "%$search%")->whereNull('deleted_at')->get();
        foreach ($results as $result) {
            array_push($result_array, array('index' => $result->id, 'value' => $result->$column));
        }
        return $result_array;
    }
}
