<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Activity extends BaseModel {
    
	use SoftDeletes;
	protected $table = 'activity_log';
    protected static $logAttributes = [];
    protected $fillable = [];
    public $searchable = ['imports.id', 'imports.filename', 'imports.original_filename'/*, 'companies.name'*/];
    public $default_sort = 'id';
    public $default_sort_order = 'asc';
	public $model = 'activity';
	// CONCAT(UPPER(SUBSTRING(activity_log.description,1,1)),LOWER(SUBSTRING(activity_log.description,2)))
	public $select_fields = ['activity_log.id', 'CONCAT(UPPER(SUBSTRING(activity_log.description,1,1)),LOWER(SUBSTRING(activity_log.description,2))) as description', 'activity_log.subject_id', 'activity_log.subject_type', 'activity_log.properties', 'CONCAT(users.first_name," ",users.last_name) as causer', 'activity_log.created_at'];
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'description' => array(
            'field_name' => 'description',
            'db_name' => 'description',
            'type' => 'text',
            'placeholder' => 'Action',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'subject_id' => array(
            'field_name' => 'subject_id',
            'db_name' => 'subject_id',
            'type' => 'text',
            'placeholder' => 'Module Id',
            'listing' => false,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'subject_type' => array(
            'field_name' => 'subject_type',
            'db_name' => 'subject_type',
            'type' => 'text',
            'placeholder' => 'Module',
            'listing' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'show_in_form' => false
		),
        'causer_id' => array(
            'field_name' => 'causer_id',
            'db_name' => 'causer_id',
            'type' => 'text',
            'placeholder' => 'Causer',
            'listing' => false,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'show_in_form' => false
		),
        'causer' => array(
            'field_name' => 'causer',
            'db_name' => 'causer_id',
            'type' => 'text',
            'placeholder' => 'Causer',
            'listing' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'show_in_form' => false
		),
        'properties' => array(
            'field_name' => 'properties',
            'db_name' => 'properties',
            'type' => 'text',
            'placeholder' => 'Properties',
            'listing' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'show_in_form' => false
		),
        'created_at' => array(
            'field_name' => 'created_at',
            'db_name' => 'created_at',
            'type' => 'date',
            'placeholder' => 'Date',
            'listing' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50',
            'show_in_form' => false
        )
    );
    
    function __construct() {
        $this->fields_array['company_id']['options'] = $this->getCompanies();
    }
    
    public function getListQuery(Request $request) {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)
				->select(DB::raw($raw_sql))
                ->leftJoin('users', 'activity_log.causer_id', '=', 'users.id');

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];

            foreach ($where_fields as $key => $where_field) {
                $query->where($where_field, $where_values[$key]);
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        // $query->where('imports.deleted_at', null);
        $query->orderBy($sort, $sort_order);

        return $query;
    }

}
