<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Action extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['name', 'code', 'description'];
    protected $fillable = ['name', 'code', 'description'];
    public $searchable = ['name', 'code', 'description'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'action';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'name' => array(
            'field_name' => 'name',
            'db_name' => 'name',
            'type' => 'text',
            'placeholder' => 'Name',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'code' => array(
            'field_name' => 'code',
            'db_name' => 'code',
            'type' => 'text',
            'placeholder' => 'Code',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'description' => array(
            'field_name' => 'description',
            'db_name' => 'description',
            'type' => 'textarea',
            'placeholder' => 'Description',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        )
    );
}
