<?php

namespace App\Http\Middleware;

use DB;
use Closure;
use App\Http\Traits\Helper;

class CheckPermissionMiddleware
{

    protected $no_auth_required = ['login', 'register', 'forgot-password', 'notifications', 'user/groups', 'user/getmessages', 'user/savemessage'];
    protected $except = ['changelogs', 'faqs', 'fetchDropdownOptions',];

    public function handle($request, Closure $next)
    {
        $user = $request->user();
        $path = substr($request->path(), 4);
        $no_check = array_merge($this->no_auth_required, $this->except);
        foreach ($no_check as $nar) {
            if (strpos($path, $nar) !== false) {
                return $next($request);
            }
        }
        if ($this->checkPermission($path, $user))
            return $next($request);
        else
            //return $next($request);
            return response()->json(['error' => "You don't have permission to perform this action"], 403);;
    }

    public function checkPermission($path, $user)
    {
        $exploded_path = explode('/', $path);
        $module = $exploded_path[0];
        $action = isset($exploded_path[1]) ? $exploded_path[1] : '';
        switch ($action) {
            case 'testConnection':
            case 'save':
            case 'createView':
                $action = 'add';
                break;
            case 'update':
            case 'view':
                $action = 'edit';
                break;
            case 'deletePermanently':
            case 'restore':
            case 'delete':
                $action = 'delete';
                break;
            case 'assign':
                $action = 'assign';
                break;
            case 'unassign':
                $action = 'unassign';
                break;
            case '':
                $action = 'list';
                break;
            default:
                $action = '';
                break;
        }
        if ($user->hasAnyPermission(["$action-all-$module", "$action-group-$module", "$action-owner-$module"])) {
            return true;
        } else {
            return false;
        }
    }
}
