<?php

namespace App\Http\Helpers;

use Mail;
use App\Models\Emaillog;

class SendEmail
{

    //public function send($to, $from, $body, $subject, $attachment)
    public function send($to, $from, $body, $subject, $email_template_id, $attachment)
    {
        $data = ['body' => $body];
        try {
            Mail::send('mail-template', $data, function ($message) use ($to, $from, $subject, $attachment) {
                $message->from($from, 'Prayer4.me');
                $message->subject($subject);
                if (!empty($attachment)) {
                    if (!empty($attachment['file_name']))
                        $message->attach($attachment['link'], [
                            'as' => $attachment['file_name'] . '.pdf',
                            'mime' => 'application/pdf'
                        ]);
                    else
                        $message->attach($attachment['link']);
                }
                $message->to($to);
            });
        } catch (\Exception $ex) {
            throw new \Exception($ex->getMessage());
        }
    }
}