<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Traits\HasRoles;
use App\Http\Helpers\UploadHelper;
use App\Models\User;
use Carbon\Carbon;

class UsersController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getList(Request $request)
    {
        $trash = $request->trash;
        $response = parent::getList($request);
        if ($trash == 'true') {
            unset($response['fields']['active']);
            unset($response['fields']['attempt']);
        }
        // for ($i = 0; $i < $response['results']['results_count']; ++$i) {
        //     $singleUser = User::find($response['results']['results'][$i]->id);
        //     $response['results']['results'][$i]->roles = $singleUser->roles->pluck('name')->implode(',');
        // }
        return $response;
    }

    public function createView()
    {
        $parent_data = parent::createView();
        if (request()->user()->can('list-group-users')) : // organisational admin
            $allotedchurchdata = DB::table('church_user')->leftJoin('churches', 'churches.id', '=', 'church_user.church_id')->where('church_user.user_id', request()->user()->id)->get();
            $church_ids = [];
            foreach ($allotedchurchdata as $allotedchurch) {
                $church_ids[$allotedchurch->id] = $allotedchurch->church_name;
            }
            $parent_data['fields']['church_id']['options'] = $church_ids;
        endif;
        return $parent_data;
    }

    public function view(Request $request)
    {
        $parent_data = parent::view($request);
        if (request()->user()->can('list-group-users')) : // organisational admin
            $allotedchurchdata = DB::table('church_user')->leftJoin('churches', 'churches.id', '=', 'church_user.church_id')->where('church_user.user_id', request()->user()->id)->get();
            $church_ids = [];
            foreach ($allotedchurchdata as $allotedchurch) {
                $church_ids[$allotedchurch->id] = $allotedchurch->church_name;
            }
            $parent_data['fields']['church_id']['options'] = $church_ids;
        endif;
        return $parent_data;
    }

    public function assign(Request $request)
    {
        if ($request->role == 18) : //organization admin replicate the default email templates and verses
            $clone_email_templates = $this->getModel()->FnCloneDefaultEmailTemplates($request->id);
            $clone_bible_verses = $this->getModel()->FnCloneDefaultBibleVerses($request->id);
        endif;
        DB::table('model_has_roles')->insert(
            ['role_id' => $request->role, 'model_type' => 'App\Models\User', 'model_id' => $request->id]
        );
    }

    public function unassign(Request $request)
    {
        if ($request->role == 18) : // organization admin remove the email templates associated for the organizational admin
            DB::table('emailtemplates')->where('user_id', $request->id)->delete();
        endif;
        DB::table('model_has_roles')->where('role_id', $request->role)->where('model_id', $request->id)->delete();
    }

    public function verify(Request $request)
    {
        $message = 'Token has been expired';
        if ($request->token) {
            $user = User::where('email_verification_token', $request->token)->first();
            if ($user) {
                $user->active = 1;
                $user->email_verification_token = NULL;
                $user->email_verified_at = Carbon::now();
                $user->save();
                $id_hash = base64_encode($user->id);
                $message = 'Success';
                return redirect('/set-password?hash=' . $id_hash);
            }
        }
    }



    public function save(Request $request)
    {

        $new_request = new Request;
        $data = $request->except('avatar');
        foreach ($data as $key => $value) {
            $new_request[$key] = trim($value);
        }

        // email existance check start
        $la_getUser = \App\Models\User::where('email', trim($new_request['email']))->get()->toArray();
        if (count($la_getUser) != 0) {
            return [
                'status' => false,
                'message' => 'Email address already exists!'
            ];
        }

        // image avatar upload start
        if ($request->hasFile('avatar')) {
            try {
                $file = $request->file('avatar');
                $new_request['avatar'] = UploadHelper::UploadFile($file, 'user');
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => $e->getMessage()
                ];
            }
        } else {
            $new_request['avatar'] = null;
            // $new_request['avatar'] = \Gravatar::get($request->email);
        }

        // assign roles to newly created user based on the logged in user start
        $new_request['company_id'] = 0;
        $role_id = '';
        $new_request['notification'] = $request->notification;
        if ($request->user()->can('delete-all-roles')) { // developer account
            $new_request['notification'] = 0;
            $role_id = 17;
        }
        if ($request->user()->can('delete-group-roles')) { // superadmin account
            $role_id = 18;
            $new_request['notification'] = 0;
            $new_request['company_id'] = $request->user()->id;
        }
        if ($request->user()->can('delete-owner-roles')) { // org admin account
            $role_id = 19;
            $new_request['notification'] = ($request->notification == 0) ? 0 : 1;
            $new_request['company_id'] = $request->user()->id;
        }

        if ($request->phone) {
            $new_request['phone'] = '+1' . $request->phone;
        }

        // if logged in user is not developer then add the company id in db end        
        $new_request['identity_key'] = md5($new_request['phone'] . time());
        $new_request['email_verification_token'] = base64_encode($request->email);
        $response_from_parent = parent::save($new_request);
        $id = $response_from_parent['results']['id'];

        if ($id > 0) { // assign role as per the logged in user start
            DB::table('model_has_roles')->insert(
                ['role_id' => $role_id, 'model_type' => 'App\Models\User', 'model_id' => $id]
            );

            if (!empty($request->church_id)) :
                DB::table('church_user')->insert(
                    ['user_id' => $id, 'church_id' =>  $request->church_id]
                );
            endif;
        }
    }

    public function removeAvatar(Request $request)
    {
        $user = $request->user();
        $avatar = $user->avatar;
        if (file_exists(public_path("/uploads/users/{$avatar}"))) {
            try {
                unlink(public_path("/uploads/users/{$avatar}"));
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => 'Unable to delete avatar'
                ];
            }
        }
        $user->avatar = null;
        $user->save();
        return [
            'status' => true,
            'message' => 'Avatar has been Removed from this profile'
        ];
    }

    public function restore(Request $request)
    {
        $table = $this->getModel()->getTable();
        DB::table($table)->whereIn('id', $request->ids)->update(['deleted_at' => null]);
        $counter = count($request->ids);
        return json_encode(array('results' => array('message' => $counter)));
    }

    public function deletePermanently(Request $request)
    {
        $table = $this->getModel()->getTable();
        $result = $this->getModelNamespace()::whereIn('id', $request->ids)->forceDelete();
        $counter = count($request->ids);
        return json_encode(array('results' => array('message' => $counter)));
    }

    public function sendTestMail()
    {
        $user = new User();
        return $user->sendTestMail();
    }

    public function groups(Request $request)
    {
        $rooms = [];
        $church_id = $request->churchId;

        $query = DB::table('requester_groups')->where('company_id', $church_id)->orderBy('id', 'Desc');
        if ($request->search_room) :
            $query->where('group_id', 'like', '%' . strtolower(trim($request->search_room)) . '%');
        endif;
        $existing_rooms = ($request->existingrooms) ? $request->existingrooms : [];
        if (count($existing_rooms) > 0) :
            $existing_ids = [];
            // dd($request->existingrooms);
            foreach ($request->existingrooms as $key => $existing) :
                $existing_ids[$key] = $existing;
            endforeach;
            $query->whereNotIn('id', $existing_ids);
        endif;

        $requesterGroups = $query->get();
        foreach ($requesterGroups as $key => $singleGroup) :
            $rooms[$key]['roomId'] = $singleGroup->id;
            $rooms[$key]['roomName'] = $singleGroup->group_id;
            $rooms[$key]['expiry_status'] = ($singleGroup->expired_at > date('Y-m-d h:i:s')) ? 'Active' : 'Expired';
            $rooms[$key]['expiry_date'] = $singleGroup->expired_at;
            $rooms[$key]['now'] = date('Y-m-d h:i:s');
            $rooms[$key]['notification'] = 0;
            $rooms[$key]['notification_count'] = 0;
        endforeach;
        $current_user_data = [];
        if ($request->userId) :
            $current_user = Db::table('users')->where('identity_key', $request->userId)->get();
            $current_user_data = ['id' => $current_user[0]->id, 'name' => $current_user[0]->first_name . ' ' . $current_user[0]->last_name];
        endif;


        return json_encode(array('rooms' => $rooms, 'current_user_data' => $current_user_data));
    }



    public function getmessages(Request $request)
    {
        $chat_messages = DB::table('users_chat_details')->join('users', 'users.id', 'users_chat_details.msg_from_id')->where('group_id', $request->room_id)->orderBy('users_chat_details.id', 'ASC')->get();
        $user = DB::table('users')->where('identity_key', $request->identity)->get()->pluck('id');
        $messages = [];
        foreach ($chat_messages as $key => $single_message) :
            $messages[$key]['_id'] = $single_message->id;
            $messages[$key]['content'] = $single_message->msg_body;
            $messages[$key]['senderId'] = $single_message->msg_from_id;
            $messages[$key]['username'] = ($single_message->msg_from_id == $user[0]) ? '' : $single_message->first_name . ' ' . $single_message->last_name;
            $messages[$key]['class'] = ($single_message->msg_from_id == $user[0]) ? 'justify-content-end ml-8' : 'justify-content-start mr-8';
            $messages[$key]['message_background_class'] = ($single_message->msg_from_id == $user[0]) ? ' bg-deepink text-white' : '';
        // $messages[$key]['date'] = $single_message->id;
        // $messages[$key]['timestamp'] = $single_message->id;
        endforeach;
        $room_name  =       DB::table('requester_groups')->where('id', $request->room_id)->get();
        return json_encode(array('messages' => $messages, 'room_name' => $room_name[0]->group_id, 'expiry_status' => ($room_name[0]->expired_at > date('Y-m-d h:i:s')) ? 1 : 0));
    }

    public function savemessage(Request $request)
    {
        $user = DB::table('users')->where('identity_key', $request->identity)->get();
        // dd($user);
        $last_inserted_id = DB::table('users_chat_details')->insertGetId(
            ['msg_from_id' => $user[0]->id, 'group_id' => $request->selectedRoomId, 'msg_body' => $request->message, 'created_at' => date('Y-m-d h:i:s')]
        );
        $status = false;
        if ($last_inserted_id > 0) :
            $status = true;
            $requester_details = DB::table('requester_groups')->select('requester_groups.company_id as company_id', 'users.phone as phone')->join('users', 'users.id', 'requester_groups.requester_id')->where('requester_groups.id', $request->selectedRoomId)->get();

            // DB::table('send_twilio_messages')
            //     ->insert(
            //         array(
            //             'contact_no'     =>   $requester_details[0]->phone,
            //             'contact_subject'   =>   'Reply from prayer team member',
            //             'contact_message'     =>   $request->message,
            //             'company_id'   =>  $requester_details[0]->company_id,
            //             'send_status' => 0,
            //         )
            //     );
            $this->sendSMS($requester_details[0]->phone, 'Reply from prayer team member', $request->message, $requester_details[0]->company_id);

        endif;


        return json_encode(array(
            'status' => $status,
            'last_inserted_id' => $last_inserted_id,
            'sender_id' => $user[0]->id,
            'username' => $user[0]->first_name . ' ' . $user[0]->last_name,
        ));
    }

    public function getParticipants(Request $request)
    {
    }
}
