<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use App\Models\Module;
use App\Models\Action;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class PermissionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function generate(Request $request)
    {
        //Permission::where('name', 'LIKE', "%$request->module%")->forceDelete();

        $permissions = array();
        $permission_arr = array();
        $data = array();
        $scopes = array('all', 'owner', 'group');
        $actions = Action::All();
        $module = 'churches';
        $permissions = Permission::where('name', 'LIKE', "%$module%")->get();
        foreach ($permissions as $perm) {
            $permission_arr[] = $perm->name;
        }
        foreach ($actions as $action) {
            foreach ($scopes as $scope) {
                $permission = $action->code . '-' . $scope . '-' . $module;
                if (!in_array($permission, $permission_arr)) {
                    $data[] = array('name' => $permission);
                }
            }
        }

        Permission::insert($data);
    }

    public function test()
    {
        $role = Role::find(7);
        $role->givePermissionTo('list-all-users');
    }
}
