<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use App\Models\User;

class NotificationsController extends Controller
{

    public function stats(Request $request)
    {
        $user_showable = $users_count = $requester_showable = $requester_count = $inbound_messages_count = $inbound_showable = 0;
        $user_label_text = $requester_label_text = $inbound_label_text = '';

        $la_member = array();
        $la_requesters = array();
        $la_groups = array();
        $la_inbound = array();
        $la_outbound = array();

        switch ($request->user()->roles->first()->id) {
            case 17: // superadmin
                $la_requesters['is_showable'] = 1;
                $la_requesters['label_text'] = 'Requester(s)';
                $la_requesters['value'] = collect(\DB::select('SELECT COUNT(DISTINCT requester_id) as requester FROM requester_groups'))->first()->requester;
                $la_requesters['icon'] = 'perm_identity';

                $la_groups['is_showable'] = 1;
                $la_groups['label_text'] = 'Prayers Served';
                $la_groups['value'] = collect(\DB::select('SELECT COUNT(id) as prayer FROM requester_groups'))->first()->prayer;
                $la_groups['icon'] = 'add_alert';

                $la_inbound['is_showable'] = 1;
                $la_inbound['label_text'] = 'Inbound SMS';
                $la_inbound['value'] = collect(\DB::select('SELECT COUNT(id) as inbound FROM twilio_msg_receives'))->first()->inbound;
                $la_inbound['icon'] = 'message';

                $la_outbound['is_showable'] = 1;
                $la_outbound['label_text'] = 'Outbound SMS';
                $la_outbound['value'] = collect(\DB::select('SELECT COUNT(id) as outbound FROM notification_logs'))->first()->outbound;
                $la_outbound['icon'] = 'insert_comment';

                $la_member['is_showable'] = 1;
                $la_member['label_text'] = 'Organization(s)';
                $la_member['value'] =  DB::table('users')->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')->leftJoin('church_user', 'church_user.user_id', '=', 'users.id')->whereIn('model_has_roles.role_id', [18])->count();
                $la_member['icon'] = 'group';
                break;
            case 18: // organisation admin
                $church_ids = DB::table('church_user')->where('user_id', $request->user()->id)->get()->pluck('church_id');

                $la_requesters['is_showable'] = 1;
                $la_requesters['label_text'] = 'Requester(s)';
                $la_requesters['value'] = DB::table('requester_groups')->whereIn('company_id', $church_ids)->distinct('requester_id')->count();
                $la_requesters['icon'] = 'perm_identity';

                $la_groups['is_showable'] = 1;
                $la_groups['label_text'] = 'Prayers Served';
                $la_groups['value'] =  DB::table('requester_groups')->whereIn('company_id', $church_ids)->count('id');
                $la_groups['icon'] = 'add_alert';

                $la_inbound['is_showable'] = 1;
                $la_inbound['label_text'] = 'Inbound SMS';
                $la_inbound['value'] =    DB::table('twilio_msg_receives')->whereIn('company_id', $church_ids)->count('id');
                $la_inbound['icon'] = 'message';

                $la_outbound['is_showable'] = 1;
                $la_outbound['label_text'] = 'Outbound SMS';
                $la_outbound['value'] =   DB::table('notification_logs')->whereIn('company_id', $church_ids)->count('id');
                $la_outbound['icon'] = 'insert_comment';

                $la_member['is_showable'] = 1;
                $la_member['label_text'] = 'Prayer Member(s)';
                $la_member['value'] =  DB::table('users')->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')->leftJoin('church_user', 'church_user.user_id', '=', 'users.id')->whereIn('church_user.church_id', $church_ids)->where('model_has_roles.role_id', '=', 19)->count();
                $la_member['icon'] = 'group';
                break;
            case 19: // prayer team member
                $la_requesters['is_showable'] = 1;
                $la_requesters['label_text'] = 'Requester(s)';
                $la_requesters['value'] = $li_requestersCount = collect(\DB::select('SELECT COUNT(DISTINCT requester_id) as requester FROM requester_groups WHERE company_id = ' . $request->user()->company_id . ' OR company_id = ' . $request->user()->id))->first()->requester;
                $la_requesters['icon'] = 'perm_identity';

                $la_groups['is_showable'] = 1;
                $la_groups['label_text'] = 'Prayers Served';
                $la_groups['value'] = collect(\DB::select('SELECT COUNT(id) as prayer FROM requester_groups WHERE company_id = ' . $request->user()->company_id . ' OR company_id = ' . $request->user()->id))->first()->prayer;
                $la_groups['icon'] = 'add_alert';

                $la_inbound['is_showable'] = 1;
                $la_inbound['label_text'] = 'Inbound SMS';
                $la_inbound['value'] = collect(\DB::select('SELECT COUNT(id) as inbound FROM twilio_msg_receives WHERE company_id = ' . $request->user()->company_id . ' OR company_id = ' . $request->user()->id))->first()->inbound;
                $la_inbound['icon'] = 'message';

                $la_outbound['is_showable'] = 1;
                $la_outbound['label_text'] = 'Outbound SMS';
                $la_outbound['value'] = collect(\DB::select('SELECT COUNT(id) as outbound FROM notification_logs WHERE company_id = ' . $request->user()->company_id . ' OR company_id = ' . $request->user()->id))->first()->outbound;
                $la_outbound['icon'] = 'insert_comment';

                $la_member['is_showable'] = 0;
                $la_member['label_text'] = 'Organization(s)';
                $la_member['value'] = 0;
                $la_member['icon'] = 'group';
                break;
            case 21: // developer
                $la_requesters['is_showable'] = 1;
                $la_requesters['label_text'] = 'Requester(s)';
                $la_requesters['value'] = collect(\DB::select('SELECT COUNT(DISTINCT requester_id) as requester FROM requester_groups'))->first()->requester;
                $la_requesters['icon'] = 'perm_identity';

                $la_groups['is_showable'] = 1;
                $la_groups['label_text'] = 'Prayers Served';
                $la_groups['value'] = collect(\DB::select('SELECT COUNT(id) as prayer FROM requester_groups'))->first()->prayer;
                $la_groups['icon'] = 'add_alert';

                $la_inbound['is_showable'] = 1;
                $la_inbound['label_text'] = 'Inbound SMS';
                $la_inbound['value'] = collect(\DB::select('SELECT COUNT(id) as inbound FROM twilio_msg_receives'))->first()->inbound;
                $la_inbound['icon'] = 'message';

                $la_outbound['is_showable'] = 1;
                $la_outbound['label_text'] = 'Outbound SMS';
                $la_outbound['value'] = collect(\DB::select('SELECT COUNT(id) as outbound FROM notification_logs'))->first()->outbound;
                $la_outbound['icon'] = 'insert_comment';

                $la_member['is_showable'] = 1;
                $la_member['label_text'] = 'User(s)';
                $la_member['value'] =  DB::table('users')->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')->leftJoin('church_user', 'church_user.user_id', '=', 'users.id')->where('model_has_roles.role_id', '!=', 21)->count();
                $la_member['icon'] = 'group';
                break;
        }

        $response = array(
            'status' => '1',
            'message' => 'User Authenticated',
            'statistics' => array(
                'requesters' => $la_requesters,
                'groups' => $la_groups,
                'inbound_message' => $la_inbound,
                'outbound_message' => $la_outbound,
                'members' => $la_member,
            ),
        );
        return $response;
    }
}
