<?php
namespace App\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Routing\ControllerDispatcher;
use Illuminate\Routing\Route;
use Illuminate\Support\Str;

class DynamicRouteController extends Controller{

    // public function __construct(){
    //     $this->middleware(['role:user', 'permission:list-all-analytics']);
    // }


    /**
     *
     * @param $slug1
     * @param null $slug2
     * @return mixed
     */

    public function handle($slug1, $slug2 = null){
        $controller = 'App\Http\Controllers\\'.Str::plural(ucfirst($slug1)).'Controller';
        $action = 'getList';
        
        if(!empty($slug2)){
            $action = $slug2;
        }

        $container = app();
        $route = $container->make(Route::class);
        $controllerInstance = $container->make($controller);

        return (new ControllerDispatcher($container))->dispatch($route, $controllerInstance, $action);
    }
}