<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;

class BibleversesController extends Controller
{

    public function save(Request $request)
    {
        $new_request = new Request;
        $data = $request->except('avatar');
        foreach ($data as $key => $value) {
            $new_request[$key] = $value;
        }
        switch ($request->user()->roles->first()->id) {
            case 17: // super-admin
                $new_request['is_default'] = 0;
                $new_request['church_id'] = 0;
                break;
            case 18: // organizational admin
                $new_request['is_default'] = 1;
                $churchColl =  DB::table('church_user')->where('user_id', $request->user()->id)->get()->pluck('church_id');
                $church_id = count($churchColl) > 0 ? $churchColl['0'] : "";
                $new_request['church_id'] = $church_id;
                break;
            default:
                $new_request['is_default'] = 0;
                $new_request['church_id'] = 0;
        }
        $response_from_parent = parent::save($new_request);
    }
}
